function [Kx,M,G,L,H,betao,gammao] = Observer_controller_design(A,B,Fa,D,C,Mc,Nc)

[n,m] = size(B);
[~,q] = size(Fa);
[~,l] = size(D);
[p,~] = size(C);

% Weights
Cox = [eye(n); zeros(n+q,n)];
Coe = [zeros(n,n+q); eye(n+q)];

% Augmented system
bar_A = [A Fa; zeros(q,n+q)]; 
bar_B = [B;zeros(q,m)]; 
bar_D = [D zeros(n,q);zeros(q,l) eye(q)]; 
bar_C = [C zeros(p,q)]; 

% Solve optimization problem
Y = 0.5*ones(m,p);
N2 = pinv(C*B) - Y * (eye(p) - C*B*pinv(C*B));
Theta2 = eye(n) - B*N2*C;
D2 = [Theta2*D zeros(n,q)];
bar_D1 = bar_D;


P0 = sdpvar(n,n);
Q0 = sdpvar(n+q,n+q);
hat_P0 = sdpvar(m,m);
X10 = sdpvar(m,n);
X20 = sdpvar(n+q,p);
X30 = sdpvar(n+q,p);
gamma0 = sdpvar(1,1);
beta0 = sdpvar(1,1);

cont = [];
cont = [cont, P0 >= eps*eye(n)];
cont = [cont, Q0 >= eps*eye(n+q)];
 
cont = [cont, gamma0 >= 0];
cont = [cont, beta0 >= 0];

cont = [cont, [beta0*eye(n) P0*B - B*hat_P0;
               (P0*B - B*hat_P0)' beta0*eye(m)]];

LMI = blkvar;
LMI(1,1) = (P0*Theta2*A - B*X10) + (P0*Theta2*A - B*X10)' + 2*Nc'*Nc;
LMI(1,2) = [B*X10 P0*Fa];
LMI(1,3) = P0*D2;
LMI(1,4) = P0*Theta2*Mc;
LMI(1,5) = zeros(n,n);
LMI(1,6) = Cox';

LMI(2,2) = (Q0*bar_A - X20*bar_C*bar_A - X30*bar_C) + (Q0*bar_A - X20*bar_C*bar_A - X30*bar_C)';
LMI(2,3) = (Q0 - X20*bar_C)*bar_D1;
LMI(2,4) = zeros(n+q,n);
LMI(2,5) = (Q0 - X20*bar_C)*[Mc;zeros(q,n)];
LMI(2,6) = Coe';

LMI(3,3) = -gamma0*eye(l+q);
LMI(3,4) = zeros(l+q,n);
LMI(3,5) = zeros(l+q,n);
LMI(3,6) = zeros(l+q,2*n+q);

LMI(4,4) = -eye(n);
LMI(5,5) = -eye(n);
LMI(6,6) = -eye(2*n+q);

LMI = sdpvar(LMI);

cont = [cont, LMI <= -eps*eye(3*q+l+6*n)];
obj = 1.0e1*gamma0 + beta0;

ops = sdpsettings('solver','mosek','verbose','1');
optimize(cont,obj,ops);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%5
gammao = sqrt(value(gamma0));
betao = value(beta0);

Q = value(Q0);
hat_P = value(hat_P0);
X1 = value(X10);
X2 = value(X20);
X3 = value(X30);

Kx = inv(hat_P) * X1;
H = inv(Q)*X2;
L1 = inv(Q)*X3;

G = (eye(n+q) - H*bar_C)*bar_B;
M = (eye(n+q) - H*bar_C)*bar_A - L1*bar_C;
L2 = M*H;
L = L1 + L2;


